% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainclouds.R
\name{add_raincloud}
\alias{add_raincloud}
\title{Add a raincloud plot to a chronicle report}
\usage{
add_raincloud(
  report = "",
  dt,
  value,
  groups = NULL,
  adjust = 0.5,
  include_boxplot = TRUE,
  include_mean = FALSE,
  include_median = TRUE,
  force_all_jitter_obs = FALSE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  static = NULL,
  raincloud_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added. Default is '', an empty report.}

\item{dt}{data.frame containing the data to plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{adjust}{Width of the kernel bins. The smaller the value, the higher the resolution of the density. For full details, see ?ggplot2::stat_density.}

\item{include_boxplot}{Include a boxplot over the raincloud. Default is TRUE.}

\item{include_mean}{Mark the median of each distribution. Default is TRUE.}

\item{include_median}{Mark the mean of each distribution. Default is FALSE.}

\item{force_all_jitter_obs}{When the data has more than 1000 observations, the function will sample 1000 observations in order to keep the object reasonably small. If you need to override it, set this value to TRUE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{static}{If TRUE, the output will be static ggplot chart instead of an interactive ggplotly chart. Default is FALSE.}

\item{raincloud_title}{Title of the raincloud plot  section on the report. If NULL, chronicle will try to parse a generic title using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An rmarkdown file as a character string, now containing a chunk for adding the specified raincloud plot.
}
\description{
Add a raincloud plot to a chronicle report
}
\examples{
html_report <- add_raincloud(report = "",
                             dt = iris,
                             value = 'Sepal.Length',
                             groups = 'Species')
cat(html_report)
}
