% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{FlattenChains}
\alias{FlattenChains}
\title{Flatten chains}
\usage{
FlattenChains(chains)
}
\arguments{
\item{chains}{A cia_chains object.}
}
\value{
A cia_chain object of flattened samples.
}
\description{
Flatten a cia_chains object into a single cia_chain object. This is helpful
for when you want to calculate a feature across using all samples across
the cia_chains.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
FlattenChains(results)[1:3]

}
