% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cummean.R
\name{PlotCumulativeMeanTrace}
\alias{PlotCumulativeMeanTrace}
\title{Plot cumulative mean trace plot.}
\usage{
PlotCumulativeMeanTrace(
  x,
  ncol = NULL,
  nrow = NULL,
  scales = "fixed",
  dir = "v"
)
}
\arguments{
\item{x}{A posterior predictive sample object.}

\item{ncol}{Number of columns.}

\item{nrow}{Number of rows.}

\item{scales}{Whether the scales should the fixed ('fixed', the default),
free ('free') or free in one dimension ('free_x', 'free_y')?}

\item{dir}{Direction to fill facets. Either 'h' for horizontal or 'v' for
vertical.}
}
\value{
A ggplot object.
}
\description{
Plot cumulative mean trace plot.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)

# Sample the edge probability.
p_edge <- function(dag) { return(as.vector(dag)) }
pedge_sample <- SamplePosteriorPredictiveChains(dag_chains, p_edge)

PlotCumulativeMeanTrace(pedge_sample,
                        nrow = length(data), 
                        ncol = length(data))

}
