% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parc_utils.R
\name{parc_mean_mat}
\alias{parc_mean_mat}
\title{Make parcellation mean matrix}
\usage{
parc_mean_mat(parc)
}
\arguments{
\item{parc}{A single-column "dlabel" \code{"xifti"} object.}
}
\value{
The parcellation matrix
}
\description{
Create a matrix that compute the average value for each parcel.
}
\details{
From a single-column "dlabel" \code{"xifti"} object, make a \eqn{K \times V}
matrix where row \eqn{k} is a vector corresponding to the kth Key value,
with \eqn{1/k_i} at locations with that key value, and \eqn{0} elsewhere.
\eqn{k_i} is the total number of locations inside Key \eqn{k}.
So, the sum of each row will be \eqn{1}, and each column will only
have exactly one non-zero value (because each location only has one Key
value) except medial wall locations will have all zeroes.

Multiplying the result of \code{parc_mean_mat} with a \eqn{V \times T} matrix
of timeseries data, e.g. from \code{as.matrix(dlabel_xii)}, will yield the
average value for each Key.
}
\keyword{internal}
