% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{circ_lin_corr}
\alias{circ_lin_corr}
\title{Circular-linear correlation}
\usage{
circ_lin_corr(circ_x, lin_x, na.rm = FALSE)
}
\arguments{
\item{circ_x}{circular variable}

\item{lin_x}{linear variable}

\item{na.rm}{a logical value indicating whether NA values should be removed before the computation proceeds}
}
\value{
circular-linear correlation measure
}
\description{
\loadmathjax
Implementation of the circular-linear correlation measure introduced by Mardia (1976) and Johnson and Wehrly (1977) as cited in Jammalamadaka & Sengupta (2001).
}
\details{
This measure is computed as \mjsdeqn{r^2 = (r_{xc}^2+r_{xs}^2-2 r_{xc} r_{xs}r_{cs})/(1-r_{cs}^2)} where \mjseqn{r_{xc} = corr(x, cos(\alpha))}, \mjseqn{r_{xs} = corr(x, sin(\alpha))}, \mjseqn{r_{cs} = corr(cos(\alpha), sin(\alpha))}, and \mjseqn{\alpha} and \mjseqn{x} are the circular and linear variables, respectively.
}
\examples{

x <- rnorm(50)
a <- as.vector(circular::rvonmises(50, 0, 5))
circ_lin_corr(x + a, x)
}
\references{
{
Jammalamadaka, S. R., & SenGupta, A. (2001). Topics in Circular Statistics. WORLD SCIENTIFIC. \doi{10.1142/4031}
}
}
