% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccSegments}
\alias{ccSegments}
\title{Draw segments connecting points in a region}
\usage{
ccSegments(
  x0 = NULL,
  y0 = NULL,
  x1 = NULL,
  y1 = NULL,
  straight = FALSE,
  col = par("col"),
  lwd = par("lwd"),
  lty = par("lty"),
  ...
)
}
\arguments{
\item{x0}{x coordinates for starting points.}

\item{y0}{y coordinates for ending points.}

\item{x1}{x coordinates for starting points.}

\item{y1}{y coordinates for ending points.}

\item{straight}{Whether the segment is a straight line.}

\item{col}{Color of the segments.}

\item{lwd}{Line width of the segments.}

\item{lty}{Line type of the segments.}

\item{...}{Pass to \code{\link[graphics]{lines}}.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.segments]{circlize::circos.segments} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track <- ccTrack(ylim = c(0, 1), track.height = 0.3)
cell <- ccCell(sector.index = "a") + ccSegments(x0 = 0.7, y0 = 0.1, x1 = 0.7, y1 = 0.9)
track <- track + cell
cc + track
}
