% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_list_identity_resolution_runs}
\alias{enhancements_list_identity_resolution_runs}
\title{List runs for the given Identity Resolution job}
\usage{
enhancements_list_identity_resolution_runs(
  id,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the Identity Resolution job.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the run.}
\item{identityResolutionId}{integer, The ID of the Identity Resolution job.}
\item{state}{string, The state of the run, one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{isCancelRequested}{boolean, True if run cancel requested, else false.}
\item{createdAt}{string, The time the run was created.}
\item{startedAt}{string, The time the run started at.}
\item{finishedAt}{string, The time the run completed.}
\item{error}{string, The error, if any, returned by the run.}
\item{sampleRecordsQuery}{string, A SQL query to produce a sample of records to inspect.}
\item{expandClusterQuery}{string, A customizable query to view PII associated with resolved ids.}
\item{runMetrics}{list, A list containing the following elements: 
\itemize{
\item numRecords integer, The number of input records for this run.
\item uniqueIds integer, The number of distinct unique IDs in the input records for this run.
\item uniqueDeduplicatedIds integer, The number of resolved IDs associated with more than one unique ID in the input.
\item maxClusterSize integer, The number of records in the largest cluster of resolved IDs.
\item avgClusterSize number, The average number of records with the same resolved ID.
\item clusterSizeFrequencies object, A mapping from numbers of records with the same resolved ID (i.e., sizes of clusters) to numbers of such clusters. For example, if there were 10 clusters with 2 records each, 2 would be a key in the mapping, and 10 would be its value.
}}
}
\description{
List runs for the given Identity Resolution job
}
