% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distractors.R
\name{distractors}
\alias{distractors}
\title{Distractor statistics}
\usage{
distractors(
  x,
  key,
  wt = NULL,
  navalue = NA,
  itemcategories = NULL,
  administered = NULL
)
}
\arguments{
\item{x}{a data frame or matrix.}

\item{key}{a vector or a list indicating the keys to score the data.
If answers can only be right or wrong use a vector. If partial credits are allowed,
use a list where the first element contains the keys for full credits, and next
elements contain progressively the partial credit information.
If a test has a combination of full credit and partial credit items, leave
the full credit items as NAs in the keys for partial credit.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{navalue}{a single value indicating the score of NAs.}

\item{itemcategories}{a vector indicating all the possible categories for all
items. If NULL, possible categories will be derived from data.}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}
}
\value{
a list.
}
\description{
Summarize the statistics for each category of each item.
}
\examples{
# Full credit items
distractors(x = dichodata, key = dichokey)

# Partial credit items
distractors(x = partialdata, key = partialkey)

}
