% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{alphatest}
\alias{alphatest}
\alias{splithalf}
\title{Reliability measures}
\usage{
alphatest(x, wt = NULL)

splithalf(
  x,
  wt = NULL,
  tries = 100,
  seed = NA,
  administered = NULL,
  maxscore = NULL
)
}
\arguments{
\item{x}{a data frame or matrix of scored data.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{tries}{a numeric value indicating the number of samples for the
split-halves coefficient. Default is \code{100}.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}
    (see \sQuote{Details}).}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}

\item{maxscore}{a numeric value indicating which is the maximum score possible
per item. The minimum score is assumed to be 0. If \code{NULL} the maximum score is assumed to be
derived from the maximum value found in \code{x} or 1 if \code{x} only has 0s.}
}
\value{
a list or a numeric vector.
}
\description{
Estimates the Cronbach's alpha coefficients and the split-halves coefficient
for a scored matrix.
}
\examples{
# No weights
ex <- correct(x = dichodata, key = dichokey, navalue = NA)
alphatest(ex)
splithalf(ex, tries = 5)


# With weights
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)
alphatest(ex,wt = wt)
splithalf(ex,wt = wt, tries = 5)

}
