% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{adj_rand_index}
\alias{adj_rand_index}
\title{Adjusted Rand Index Between Clusterings}
\usage{
adj_rand_index(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\description{
Computes the adjusted Rand index (ARI) between two clusterings,
such as a predicted and ground truth clustering.
}
\details{
The adjusted Rand index (ARI) is a variant of the Rand index (RI)
which is corrected for chance using the Permutation Model for
clusterings. It is related to the RI as follows:
\deqn{\frac{RI - E(RI)}{1 - E(RI)},}{(RI - E(RI))/(1 - E(RI)),}
where \eqn{E(RI)} is the expected value of the RI under the Permutation
Model.
Unlike the RI, the ARI takes values in the range -1 to 1. A value
of 1 indicates that the clusterings are identical, while a value of
0 indicates the clusterings are drawn randomly independent of one
another.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
adj_rand_index(true, pred)

}
\references{
Hubert, L., Arabie, P. "Comparing partitions." \emph{Journal of Classification}
\strong{2}, 193–218 (1985). \doi{10.1007/BF01908075}
}
