% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_by_group.R
\name{compare_by_group}
\alias{compare_by_group}
\title{Compare Two Datasets by Group}
\usage{
compare_by_group(df1, df2, group_vars)
}
\arguments{
\item{df1}{A data frame representing the first dataset.}

\item{df2}{A data frame representing the second dataset.}

\item{group_vars}{A character vector of column names to group by.}
}
\value{
A list of comparison results for each group.
}
\description{
Compares two datasets within subgroups defined by grouping variables.
Performs separate comparisons for each group and returns results organized
by group.
}
\examples{
\donttest{
  df1 <- data.frame(region = c("A", "A", "B"), value = c(10, 20, 30),
                    stringsAsFactors = FALSE)
  df2 <- data.frame(region = c("A", "A", "B"), value = c(10, 25, 30),
                    stringsAsFactors = FALSE)
  compare_by_group(df1, df2, group_vars = "region")
}
}
