\name{acetaminophen_nomogram}
\alias{acetaminophen_nomogram}
\title{
Acetaminophen Overdose NAC Dosing (Rumack-Matthew Nomogram)
}
\description{
Determines the need for N-acetylcysteine (NAC) treatment following a single acute acetaminophen ingestion. The function utilizes the Rumack-Matthew Nomogram logic, specifically the "Treatment Line" (starting at 150 mcg/mL at 4 hours), to interpret serum acetaminophen levels obtained between 4 and 24 hours post-ingestion.
}
\usage{
acetaminophen_nomogram(time_ingestion_hrs, acetaminophen_level, units = "mcg/mL")
}
\arguments{
  \item{time_ingestion_hrs}{
Numeric. Time passed since the ingestion in hours. The nomogram is valid only for single acute ingestions between 4 and 24 hours.
}
  \item{acetaminophen_level}{
Numeric. The measured serum acetaminophen concentration.
}
  \item{units}{
String. Units of the concentration measurement. Options:
"mcg/mL" (default)
"mg/L"
"mg/dL"
"micromol/L"
}
}
\value{
A list containing:
\item{Standardized_Level_mcg_mL}{The input level converted to mcg/mL.}
\item{Treatment_Threshold_mcg_mL}{The nomogram threshold value for the specific time provided.}
\item{Recommendation}{Clinical guidance based on whether the level falls above or below the treatment line.}
}
\references{
Rumack BH, Matthew H. Acetaminophen poisoning and toxicity. Pediatrics. 1975;55(6):871-876.
}
\examples{

# Example 1: Treatment Needed
# 8 hours post-ingestion, Level 100 mcg/mL
# Threshold at 8 hours is 75 mcg/mL -> Above line
acetaminophen_nomogram(8, 100, "mcg/mL")

# Example 2: No Treatment
# 5 hours post-ingestion, Level 100 mcg/mL
# Threshold at 5 hours is ~126 mcg/mL -> Below line
acetaminophen_nomogram(5, 100, "mcg/mL")

# Example 3: Different Units
# 4 hours post, Level 20 mg/dL -> Converts to 200 mcg/mL (Above 150 threshold)
acetaminophen_nomogram(4, 20, "mg/dL")
}
