\name{ain_risk_calculator}
\alias{ain_risk_calculator}
\title{
Acute Interstitial Nephritis (AIN) Risk Calculator
}
\description{
Calculates the probability of biopsy-proven Acute Interstitial Nephritis (AIN) in patients with acute kidney injury. This model uses variables from the electronic health record (Serum Creatinine, BUN, Urine Specific Gravity, and Urine Protein) to differentiate AIN from other causes of AKI (e.g., Acute Tubular Necrosis). The formula is derived from Moledina et al. and includes an adjustment for local disease prevalence.
}
\usage{
ain_risk_calculator(creatinine, bun, urine_specific_gravity,
                    urine_protein_high, local_ain_prevalence = 0.23)
}
\arguments{
  \item{creatinine}{
Numeric. Serum creatinine in mg/dL.
}
  \item{bun}{
Numeric. Blood Urea Nitrogen in mg/dL.
}
  \item{urine_specific_gravity}{
Numeric. Specific gravity from urine dipstick or analysis (e.g., 1.015).
}
  \item{urine_protein_high}{
Numeric (0 or 1). Urine dipstick protein result.
0: Trace/1+ or lower (Low Protein).
1: 2+ or higher (High Protein).
Note: High protein reduces the probability of AIN in this model.
}
  \item{local_ain_prevalence}{
Numeric. The estimated prevalence of AIN in the biopsy population at the local institution. Defaults to 0.23 (23\%).
}
}
\value{
A list containing:
\item{Probability_AIN_Percent}{The calculated probability of AIN as a percentage.}
\item{Interpretation}{Risk categorization (Low <20\%, Intermediate 20-50\%, High >=50\%).}
}
\references{
Moledina DG, Wilson FP, Puthumana J, et al. Development and External Validation of a Diagnostic Model for Biopsy-Proven Acute Interstitial Nephritis Using Electronic Health Record Data. J Clin Invest. 2019;133(13):e168950.
}
\examples{

# Example 1: High Risk AIN
# High Cr, Low BUN/Cr ratio, Low SG, Low Protein
ain_risk_calculator(4.0, 40, 1.010, 0)

# Example 2: Low Risk AIN (Likely ATN/Glomerular)
# Lower Cr, High Ratio, High SG, High Protein
ain_risk_calculator(1.5, 30, 1.020, 1)
}
