\name{ecog_performance_status}
\alias{ecog_performance_status}
\title{
Eastern Cooperative Oncology Group (ECOG) Performance Status
}
\description{
Retrieves the definition for the ECOG Performance Status grade. This scale is used by doctors and researchers to assess how a patient's disease is progressing, assess how the disease affects the daily living abilities of the patient, and determine appropriate treatment and prognosis.
}
\usage{
ecog_performance_status(grade)
}
\arguments{
  \item{grade}{
Numeric (0-5). The assigned performance status grade.
0: Fully active.
1: Restricted strenuous activity, ambulatory.
2: Ambulatory, self-care, no work.
3: Limited self-care, >50\% bed/chair.
4: Completely disabled.
5: Dead.
}
}
\value{
A list containing:
\item{ECOG_Grade}{The input grade.}
\item{Definition}{The clinical description associated with the grade.}
}
\references{
Oken MM, Creech RH, Tormey DC, et al. Toxicity and response criteria of the Eastern Cooperative Oncology Group. Am J Clin Oncol. 1982;5(6):649-655. doi:10.1097/00000421-198212000-00014
}
\examples{

# Example 1: Ambulatory patient unable to work
ecog_performance_status(2)

# Example 2: Fully active patient
ecog_performance_status(0)
}
