\name{qids_depression_score}
\alias{qids_depression_score}
\title{
Quick Inventory of Depressive Symptomatology (QIDS-SR16)
}
\description{
Calculates the QIDS total score based on 16 items that assess the severity of depressive symptoms. The scoring logic groups the 16 items into 9 clinical domains (matching DSM criteria), taking the highest score within a specific domain (e.g., Sleep, Appetite/Weight, Psychomotor) as the score for that domain.
}
\usage{
qids_depression_score(sleep_onset, sleep_mid_nocturnal, sleep_early_waking,
                      sleep_hypersomnia, mood_sadness, appetite_decreased,
                      appetite_increased, weight_decreased, weight_increased,
                      concentration, view_of_self, thoughts_death_suicide,
                      general_interest, energy_level, psychomotor_slowing,
                      psychomotor_agitation)
}
\arguments{
  \item{sleep_onset}{Numeric (0-3). Q1: Falling asleep.}
  \item{sleep_mid_nocturnal}{Numeric (0-3). Q2: Sleep during the night.}
  \item{sleep_early_waking}{Numeric (0-3). Q3: Waking up too early.}
  \item{sleep_hypersomnia}{Numeric (0-3). Q4: Sleeping too much.}
  \item{mood_sadness}{Numeric (0-3). Q5: Feeling sad.}
  \item{appetite_decreased}{Numeric (0-3). Q6: Decreased appetite.}
  \item{appetite_increased}{Numeric (0-3). Q7: Increased appetite.}
  \item{weight_decreased}{Numeric (0-3). Q8: Decreased weight (within last 2 weeks).}
  \item{weight_increased}{Numeric (0-3). Q9: Increased weight (within last 2 weeks).}
  \item{concentration}{Numeric (0-3). Q10: Concentration / Decision making.}
  \item{view_of_self}{Numeric (0-3). Q11: View of myself.}
  \item{thoughts_death_suicide}{Numeric (0-3). Q12: Thoughts of death or suicide.}
  \item{general_interest}{Numeric (0-3). Q13: General interest.}
  \item{energy_level}{Numeric (0-3). Q14: Energy level.}
  \item{psychomotor_slowing}{Numeric (0-3). Q15: Feeling slowed down.}
  \item{psychomotor_agitation}{Numeric (0-3). Q16: Feeling restless.}
}
\value{
A list containing:
\item{QIDS_Total_Score}{The sum of the 9 domain scores (Range 0-27).}
\item{Severity_Category}{Interpretation (None, Mild, Moderate, Severe, Very Severe).}
\item{Domain_Scores}{The specific scores calculated for the 9 domains.}
}
\references{
Rush AJ, Trivedi MH, Ibrahim HM, et al. The 16-Item Quick Inventory of Depressive Symptomatology (QIDS), clinician rating (QIDS-C), and self-report (QIDS-SR): a psychometric evaluation in patients with chronic major depression. Biol Psychiatry. 2003;54(5):573-583. doi:10.1016/s0006-3223(02)01866-8
}
\examples{

# Example 1: Severe Depression
# High scores in sleep (max 3), sadness (3), energy (3), suicide (1)
qids_depression_score(3, 2, 1, 0, 3, 0, 0, 0, 0, 2, 2, 1, 2, 3, 1, 0)

# Example 2: Normal
# All items 0
qids_depression_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
