\name{risk_malignancy_index}
\alias{risk_malignancy_index}
\title{
Risk of Malignancy Index (RMI) for Ovarian Cancer
}
\description{
Calculates the Risk of Malignancy Index (RMI I) to stratify the risk of ovarian cancer in women with adnexal masses. The score combines serum CA-125 levels, ultrasound findings, and menopausal status. An RMI score greater than 200 suggests a higher risk of malignancy and typically warrants referral to a gynecological oncologist.
}
\usage{
risk_malignancy_index(ca125_level, menopausal_status, multilocular_cyst,
                      solid_areas, bilateral_lesions, ascites,
                      intraabdominal_metastases)
}
\arguments{
  \item{ca125_level}{
Numeric. Serum CA-125 level in U/mL.
}
  \item{menopausal_status}{
String. "pre" (1 point) or "post" (3 points). Post-menopausal is defined as >1 year of amenorrhea or age >50 in hysterectomized women.
}
  \item{multilocular_cyst}{
Numeric (0 or 1). Presence of a multilocular cystic lesion on ultrasound. (1 = Yes).
}
  \item{solid_areas}{
Numeric (0 or 1). Presence of solid areas within the mass on ultrasound. (1 = Yes).
}
  \item{bilateral_lesions}{
Numeric (0 or 1). Presence of bilateral lesions on ultrasound. (1 = Yes).
}
  \item{ascites}{
Numeric (0 or 1). Presence of ascites on ultrasound. (1 = Yes).
}
  \item{intraabdominal_metastases}{
Numeric (0 or 1). Presence of intra-abdominal metastases on ultrasound. (1 = Yes).
}
}
\details{
The formula for RMI I is:
\deqn{RMI = U \times M \times CA125}
Where:
\itemize{
  \item \strong{U (Ultrasound Score)}: 0 if no features, 1 if 1 feature, 3 if 2-5 features.
  \item \strong{M (Menopausal Status)}: 1 if Pre-menopausal, 3 if Post-menopausal.
  \item \strong{CA125}: Absolute value of serum CA-125.
}
}
\value{
A list containing:
\item{RMI_Score}{The calculated Risk of Malignancy Index.}
\item{Risk_Category}{Interpretation based on the threshold of 200 (High vs. Low).}
\item{Recommendation}{Referral guidance.}
}
\references{
Jacobs I, Oram D, Fairbanks J, et al. A risk of malignancy index incorporating CA 125, ultrasound and menopausal status for the accurate preoperative diagnosis of ovarian cancer. Br J Obstet Gynaecol. 1990;97(10):922-929. doi:10.1111/j.1471-0528.1990.tb02448.x
}
\examples{

# Example 1: High Risk
# CA125 100, Post-menopausal (3), 2 US features (Solid, Ascites -> U=3)
# RMI = 3 * 3 * 100 = 900
risk_malignancy_index(100, "post", 0, 1, 0, 1, 0)

# Example 2: Low Risk
# CA125 25, Pre-menopausal (1), 1 US feature (Multilocular -> U=1)
# RMI = 1 * 1 * 25 = 25
risk_malignancy_index(25, "pre", 1, 0, 0, 0, 0)
}
