\name{rome_iv_functional_bloating_distension}
\alias{rome_iv_functional_bloating_distension}
\title{
Rome IV Diagnostic Criteria for Functional Abdominal Bloating/Distension
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Abdominal Bloating/Distension. Diagnosis requires recurrent bloating and/or distension occurring at least 1 day/week, which predominates over other symptoms, in the absence of criteria for IBS, functional constipation, functional diarrhea, or postprandial distress syndrome. Symptoms must have started at least 6 months ago and been active for the last 3 months.
}
\usage{
rome_iv_functional_bloating_distension(bloating_distension_ge_1_day_week,
                                       symptoms_predominate,
                                       criteria_for_other_fgid_met,
                                       symptom_onset_ge_6_months,
                                       symptoms_active_last_3_months)
}
\arguments{
  \item{bloating_distension_ge_1_day_week}{
Numeric (0 or 1). Recurrent bloating and/or distension occurring on average at least 1 day per week. (1 = Yes).
}
  \item{symptoms_predominate}{
Numeric (0 or 1). Do abdominal bloating and/or distension predominate over other symptoms? (1 = Yes). Note: Mild pain related to bloating/distension is allowed.
}
  \item{criteria_for_other_fgid_met}{
Numeric (0 or 1). Does the patient meet criteria for Irritable Bowel Syndrome (IBS), Functional Constipation, Functional Diarrhea, or Postprandial Distress Syndrome? (1 = Yes). Note: A "Yes" here excludes Functional Bloating/Distension.
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been present for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Abdominal Bloating/Distension" or "Criteria Not Met".}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# Bloating >1/wk, Predominates, No other FGID, Chronic duration
rome_iv_functional_bloating_distension(1, 1, 0, 1, 1)

# Example 2: Not Met (Meets IBS criteria)
# Bloating present, but IBS criteria also met (1)
rome_iv_functional_bloating_distension(1, 1, 1, 1, 1)
}
