\name{uceis_score}
\alias{uceis_score}
\title{
Ulcerative Colitis Endoscopic Index of Severity (UCEIS)
}
\description{
Calculates the UCEIS score, a validated instrument for assessing endoscopic disease activity in Ulcerative Colitis. The score is the sum of three descriptors: vascular pattern, bleeding, and erosions/ulcers. The total score ranges from 0 to 8.
}
\usage{
uceis_score(vascular_pattern, bleeding, erosions_ulcers)
}
\arguments{
  \item{vascular_pattern}{
Numeric (0-2). Assessment of vascular pattern.
0: Normal.
1: Patchy obliteration.
2: Obliterated.
}
  \item{bleeding}{
Numeric (0-3). Assessment of bleeding.
0: None.
1: Mucosal.
2: Luminal mild.
3: Luminal moderate or severe.
}
  \item{erosions_ulcers}{
Numeric (0-3). Assessment of erosions and ulcers.
0: None.
1: Erosions.
2: Superficial ulcer.
3: Deep ulcer.
}
}
\value{
A list containing:
\item{UCEIS_Score}{The calculated total score (Range 0-8).}
\item{Disease_Activity}{Interpretation of severity (Remission <=1, Moderate-Severe >4).}
}
\references{
Travis SP, Schnell D, Krzeski P, et al. Developing an instrument to assess the endoscopic severity of ulcerative colitis: the Ulcerative Colitis Endoscopic Index of Severity (UCEIS). Gut. 2012;61(4):535-542. doi:10.1136/gutjnl-2011-300207
Ikeya K, Shih DQ, Takano R, et al. Correlating the Ulcerative Colitis Endoscopic Index of Severity with Clinical Outcomes: A Prospective Study. Dig Dis Sci. 2016;61(10):2983-2990.
}
\examples{

# Example 1: Severe Disease
# Obliterated vascular (2), Luminal mild bleeding (2), Deep ulcers (3)
# Score = 7
uceis_score(2, 2, 3)

# Example 2: Remission
# Normal vascular (0), No bleeding (0), No erosions (0)
# Score = 0
uceis_score(0, 0, 0)
}
