\name{acep_covid19_management}
\alias{acep_covid19_management}
\title{
ACEP ED COVID-19 Management Tool (Severity Classification)
}
\description{
Classifies the severity of COVID-19 infection in adult patients presenting to the Emergency Department based on the American College of Emergency Physicians (ACEP) COVID-19 Management Tool guidelines. The classification (Mild, Moderate, Severe, Critical) is used to guide diagnostic testing, disposition, and treatment decisions.
}
\usage{
acep_covid19_management(spo2, resp_rate, signs_of_shock_mods = FALSE,
                        resp_failure = FALSE, lower_resp_disease = FALSE,
                        infiltrates_gt_50 = FALSE, pao2_fio2 = NULL,
                        symptoms_present = TRUE)
}
\arguments{
  \item{spo2}{
Numeric. Oxygen saturation (\%) on room air.
}
  \item{resp_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{signs_of_shock_mods}{
Logical. Presence of septic shock or multiple organ dysfunction syndrome (MODS).
}
  \item{resp_failure}{
Logical. Presence of respiratory failure requiring advanced support.
}
  \item{lower_resp_disease}{
Logical. Evidence of lower respiratory disease during clinical assessment or imaging (e.g., pneumonia).
}
  \item{infiltrates_gt_50}{
Logical. Lung infiltrates > 50\% on chest imaging.
}
  \item{pao2_fio2}{
Numeric (Optional). Ratio of arterial partial pressure of oxygen to fraction of inspired oxygen (PaO2/FiO2).
}
  \item{symptoms_present}{
Logical. Presence of any COVID-19 symptoms (fever, cough, etc.). Defaults to TRUE.
}
}
\value{
A list containing:
\item{Severity_Classification}{The assigned severity category (Mild, Moderate, Severe, Critical).}
\item{Clinical_Definition}{Description of the criteria met for the classification.}
\item{Suggested_Management}{General disposition and treatment recommendations based on ACEP guidelines.}
}
\references{
American College of Emergency Physicians (ACEP). ACEP COVID-19 Field Guide: Emergency Department COVID-19 Management Tool. 2023 Update.
}
\examples{

# Example 1: Severe Illness
# SpO2 92\%, RR 22, Positive Infiltrates (but not >50\%)
# Severity driven by Hypoxia (SpO2 < 94\%)
acep_covid19_management(spo2 = 92, resp_rate = 22, lower_resp_disease = TRUE)

# Example 2: Mild Illness
# SpO2 98\%, RR 16, Symptoms present, No lower respiratory disease
acep_covid19_management(spo2 = 98, resp_rate = 16, lower_resp_disease = FALSE)

# Example 3: Critical Illness
# Shock present
acep_covid19_management(spo2 = 88, resp_rate = 35, signs_of_shock_mods = TRUE)
}
