\name{chosen_covid_risk_score}
\alias{chosen_covid_risk_score}
\title{
CHOSEN Risk Score for COVID-19 Safe Discharge
}
\description{
Calculates the CHOSEN (COVID Home Safely Now) score to predict the likelihood of a safe discharge for patients with COVID-19. The model uses Age, Sex, Respiratory Rate, Oxygen Saturation, and Albumin to estimate the probability of not requiring ICU admission, intubation, or dying (safe discharge).
}
\usage{
chosen_covid_risk_score(age, sex, respiratory_rate, spo2, albumin,
                        albumin_units = "g/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{spo2}{
Numeric. Oxygen saturation on room air (\%).
}
  \item{albumin}{
Numeric. Serum albumin level.
}
  \item{albumin_units}{
String. Units for albumin. "g/dL" (default) or "g/L".
}
}
\value{
A list containing:
\item{Probability_Safe_Discharge}{The estimated percentage chance of a safe outcome (no ICU/Intubation/Death).}
\item{Risk_Category}{Classification (Low/Safe, Intermediate, High/Unsafe).}
\item{Recommendation}{Clinical guidance regarding discharge vs. admission.}
}
\references{
Chopra V, et al. Development and Validation of a Score to Predict Safe Discharge in Patients with COVID-19. Detroit Medical Center. 2020. (Contextual reference).
}
\examples{

# Example 1: Safe Candidate
# 40yo Female, RR 16, SpO2 98\%, Alb 4.0
chosen_covid_risk_score(40, "female", 16, 98, 4.0)

# Example 2: High Risk
# 75yo Male, RR 24, SpO2 92\%, Alb 2.5
chosen_covid_risk_score(75, "male", 24, 92, 2.5)
}
