\name{ransons_criteria}
\alias{ransons_criteria}
\title{
Ranson's Criteria for Pancreatitis Mortality
}
\description{
Calculates the Ranson's Criteria score to predict the mortality risk of patients with acute pancreatitis. The score evaluates 11 parameters measured at admission and at 48 hours. Different scoring thresholds apply depending on whether the pancreatitis is biliary (gallstone-induced) or non-biliary (e.g., alcoholic).
}
\usage{
ransons_criteria(age, wbc_count, glucose_mg_dl, ldh, ast,
                 hct_fall_percent, bun_increase_mg_dl, calcium_mg_dl,
                 pao2_mmhg, base_deficit_meq_l, fluid_sequestration_liters,
                 etiology = "non_biliary")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{wbc_count}{
Numeric. White Blood Cell count (cells/mm^3 or uL).
}
  \item{glucose_mg_dl}{
Numeric. Blood glucose level in mg/dL.
}
  \item{ldh}{
Numeric. Lactate Dehydrogenase level in IU/L.
}
  \item{ast}{
Numeric. Aspartate Aminotransferase level in IU/L.
}
  \item{hct_fall_percent}{
Numeric. Drop in hematocrit percentage points within 48 hours.
}
  \item{bun_increase_mg_dl}{
Numeric. Increase in Blood Urea Nitrogen in mg/dL within 48 hours.
}
  \item{calcium_mg_dl}{
Numeric. Serum Calcium level in mg/dL at 48 hours.
}
  \item{pao2_mmhg}{
Numeric. Arterial PO2 in mmHg at 48 hours. (Only scored for non-biliary etiology in standard Ranson's, though often collected).
}
  \item{base_deficit_meq_l}{
Numeric. Base deficit in mEq/L at 48 hours.
}
  \item{fluid_sequestration_liters}{
Numeric. Estimated fluid sequestration in Liters at 48 hours.
}
  \item{etiology}{
String. Cause of pancreatitis. Options: "non_biliary" (default) or "biliary".
}
}
\value{
A list containing:
\item{Ranson_Score}{The calculated total score (Range 0-11 for non-biliary, 0-10 for biliary).}
\item{Mortality_Risk}{Estimated mortality percentage associated with the score.}
}
\references{
Ranson JH, Rifkind KM, Roses DF, et al. Prognostic signs and the role of operative management in acute pancreatitis. Surg Gynecol Obstet. 1974;139(1):69-81.
Ranson JH. Etiological and prognostic factors in human acute pancreatitis: a review. Am J Gastroenterol. 1982;77(9):633-638.
}
\examples{

# Example 1: Non-Biliary (Alcohol), Severe
# Age 60 (+1), WBC 18k (+1), Glu 250 (+1), LDH 400 (+1), AST 300 (+1)
# 48h: Hct drop 12 (+1), BUN up 10 (+1), Ca 7 (+1), PaO2 55 (+1), BD 5 (+1), Fluid 7 (+1)
# Score = 11
ransons_criteria(60, 18000, 250, 400, 300, 12, 10, 7, 55, 5, 7, "non_biliary")

# Example 2: Biliary, Moderate
# Age 75 (+1), WBC 19k (+1), Glu 150 (0), LDH 350 (0), AST 200 (0)
# 48h: Hct drop 5 (0), BUN up 1 (0), Ca 9 (0), PaO2 70, BD 2 (0), Fluid 3 (0)
# Score = 2
ransons_criteria(75, 19000, 150, 350, 200, 5, 1, 9, 70, 2, 3, "biliary")
}
