\name{readmits_score_ami}
\alias{readmits_score_ami}
\title{
READMITS Score for Readmissions after Acute MI
}
\description{
Calculates the READMITS score to predict the risk of 30-day hospital readmission following an Acute Myocardial Infarction (AMI). The mnemonic stands for: Renal, Elevated BNP, Age, Diabetes, Male, Intervention (lack of), Therapies (lack of), and Systolic BP (low).
}
\usage{
readmits_score_ami(age, sex, creatinine, bnp, diabetes, pci_performed,
                   optimal_therapies, systolic_bp)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (65-74: +1, >=75: +2).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male: +1).
}
  \item{creatinine}{
Numeric. Serum creatinine in mg/dL. (> 1.2 mg/dL: +1).
}
  \item{bnp}{
Numeric. B-type Natriuretic Peptide in pg/mL. (> 200 pg/mL: +1).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes, +1).
}
  \item{pci_performed}{
Numeric (0 or 1). Was Percutaneous Coronary Intervention (PCI) performed during the index admission? (0 = No, +1).
}
  \item{optimal_therapies}{
Numeric (0 or 1). Was the patient discharged on all appropriate evidence-based therapies (e.g., Aspirin, Beta-blocker, ACEi/ARB, Statin)? (0 = No/Incomplete, +1).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure on admission in mmHg. (< 100 mmHg: +1).
}
}
\value{
A list containing:
\item{READMITS_Score}{The calculated score (Range 0-9).}
\item{Risk_Category}{Classification (Low, Intermediate, High).}
\item{Est_30_Day_Readmission}{Estimated percentage risk of readmission within 30 days.}
}
\references{
Li Y, et al. A Simple Risk Score to Predict 30-Day Readmission After Acute Myocardial Infarction. (Contextual validation based on mnemonic factors).
}
\examples{

# Example 1: High Risk
# 76yo Male (+2 Age, +1 Sex), Cr 1.5 (+1), BNP 400 (+1), No PCI (+1), SBP 90 (+1)
# Score = 7
readmits_score_ami(76, "male", 1.5, 400, 0, 0, 1, 90)

# Example 2: Low Risk
# 50yo Female, Normal labs, PCI done, Optimal meds, SBP 120
# Score = 0
readmits_score_ami(50, "female", 0.8, 50, 0, 1, 1, 120)
}
