\name{respiratory_score_asthma_liu}
\alias{respiratory_score_asthma_liu}
\title{
Respiratory Score (Asthma) - Liu et al.
}
\description{
Calculates the Liu Respiratory Score to assess the severity of acute asthma exacerbations in children. The score is based on three clinical parameters: Respiratory Rate (age-adjusted), Wheezing, and Retractions/Accessory Muscle Use.
}
\usage{
respiratory_score_asthma_liu(age_years, respiratory_rate, wheezing_score,
                             retractions_score)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. Used to stratify respiratory rate scoring (<2y, 2-5y, >5y).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
Scoring:
<2y: <40(0), 40-59(1), 60-69(2), >=70(3).
2-5y: <30(0), 30-39(1), 40-49(2), >=50(3).
>5y: <20(0), 20-24(1), 25-29(2), >=30(3).
}
  \item{wheezing_score}{
Numeric (0-3).
0: None.
1: End-expiratory only.
2: Throughout expiration.
3: Inspiration and expiration.
}
  \item{retractions_score}{
Numeric (0-3). Accessory muscle use/Retractions.
0: None.
1: 1 site (e.g., subcostal).
2: 2 sites (e.g., subcostal and intercostal).
3: 3 sites (e.g., subcostal, intercostal, substernal) or nasal flaring.
}
}
\value{
A list containing:
\item{Respiratory_Score}{The calculated total score (Range 0-9).}
\item{Severity_Classification}{Interpretation (Mild <= 3, Moderate 4-7, Severe >= 8).}
}
\references{
Liu LL, Gallaher MM, Davis RL, et al. Use of a respiratory clinical score to predict the outcome of acute asthma in children. Pediatr Emerg Care. 2004;20(4):243-247. doi:10.1097/01.pec.0000121243.13322.42
}
\examples{

# Example 1: Moderate Exacerbation (3yo)
# RR 35 (1 pt), Wheeze entire exp (2 pts), 1 site retraction (1 pt)
# Score = 4
respiratory_score_asthma_liu(3, 35, 2, 1)

# Example 2: Severe Exacerbation (7yo)
# RR 32 (3 pts), Wheeze Insp/Exp (3 pts), 2 sites (2 pts)
# Score = 8
respiratory_score_asthma_liu(7, 32, 3, 2)
}
