\name{shortened_mfis_score}
\alias{shortened_mfis_score}
\title{
Shortened Modified Fatigue Impact Scale (MFIS-5)
}
\description{
Calculates the score for the 5-item Shortened Modified Fatigue Impact Scale (MFIS-5). This tool assesses the impact of fatigue on physical, cognitive, and psychosocial functioning in patients with multiple sclerosis (MS). It is a subset of the full 21-item MFIS.
}
\usage{
shortened_mfis_score(less_alert, limit_physical_tasks, sustain_physical_effort,
                     limit_clear_thinking, trouble_concentrating)
}
\arguments{
  \item{less_alert}{
Numeric (0-4). "I have been less alert." (0=Never, 4=Almost always).
}
  \item{limit_physical_tasks}{
Numeric (0-4). "I have been less able to complete tasks that require physical effort." (0=Never, 4=Almost always).
}
  \item{sustain_physical_effort}{
Numeric (0-4). "I have had trouble maintaining physical effort for long periods." (0=Never, 4=Almost always).
}
  \item{limit_clear_thinking}{
Numeric (0-4). "I have been less able to complete tasks that require clear thinking." (0=Never, 4=Almost always).
}
  \item{trouble_concentrating}{
Numeric (0-4). "I have had trouble concentrating." (0=Never, 4=Almost always).
}
}
\details{
The MFIS-5 consists of items 1, 9, 10, 17, and 19 from the full MFIS.
Scoring for each item:
0 = Never
1 = Rarely
2 = Sometimes
3 = Often
4 = Almost always
}
\value{
A list containing:
\item{MFIS_5_Score}{The calculated total score (Range 0-20).}
\item{Interpretation}{General interpretation of the score.}
}
\references{
Fisk JD, Ritvo PG, Ross L, et al. Measuring the functional impact of fatigue: initial validation of the fatigue impact scale. Clin Infect Dis. 1994;18 Suppl 1:S79-83. doi:10.1093/clinids/18.supplement_1.s79
Multiple Sclerosis Quality of Life Inventory (MSQLI). National Multiple Sclerosis Society.
}
\examples{

# Example 1: Moderate Fatigue Impact
# Scores: 2, 3, 2, 1, 2
shortened_mfis_score(2, 3, 2, 1, 2)

# Example 2: Severe Fatigue Impact
# Scores: 4, 4, 3, 4, 3
shortened_mfis_score(4, 4, 3, 4, 3)
}
