% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/day_chart.R
\name{day_chart}
\alias{day_chart}
\title{Plot Values on a 24-Hour Day, on Specific Hours}
\usage{
day_chart(hvalue, high = "blue", low = "yellow", width = 0.8)
}
\arguments{
\item{hvalue}{A numeric vector having values at each of 24 hours (starts
from 6 am)}

\item{high}{The color name for the high values. The default is \code{red}}

\item{low}{The color name for the low values. The default is \code{green}.}

\item{width}{Width of bars}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function plots values corresponding to each hour on a rose plot.
}
\details{
The color names can be vice versa or other colors, depending on the context.
}
\examples{
value <- sample(15:30, 24, replace = TRUE)
day_chart(hvalue = value, high = "blue", low = "yellow", width = 0.8)
}
\seealso{
\code{\link[=week_chart]{week_chart()}} for plotting values in a week by days
\code{\link[=year_chart]{year_chart()}} for plotting values on in a year by months
\code{\link[=cyclic_chart]{cyclic_chart()}} for plotting values by arbitrary period
}
