% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthRateMethods.R
\name{birthDeathMCMC}
\alias{birthDeathMCMC}
\title{Growth rate estimate using MCMC}
\usage{
birthDeathMCMC(
  tree,
  maxGrowthRate = 4,
  alpha = 0.05,
  verbose = TRUE,
  nChains = 4,
  nCores = 1,
  chainLength = 2000
)
}
\arguments{
\item{tree}{An ultrametric tree subset to include only the clone of
interest. Alternatively, a list with several such trees.}

\item{maxGrowthRate}{Sets upper bound on birth rate. Default is 4 but this
will depend on the nature of the data}

\item{alpha}{Used for calculation of confidence intervals. 1-alpha confidence intervals used with default of alpha = 0.05 (95 percent confidence intervals)}

\item{verbose}{TRUE or FALSE, should the Rstan MCMC intermediate output and progress be printed?}

\item{nChains}{Number of chains to run in MCMC. Default is 4}

\item{nCores}{Number of cores to perform MCMC. Default is 1, but chains can
be run in parallel}

\item{chainLength}{Number of iterations for each chain in MCMC. Default is
2000 (1000 warm-up + 1000 sampling), increase if stan tells you to}
}
\value{
A dataframe including the net growth rate estimate, confidence
intervals, and other important details (clone age estimate, runtime, n,
etc.)
}
\description{
Uses Rstan and the No U-turn sampler to approximate the
growth rate using the likelihood from Stadler 2009 "On incomplete sampling
under birth–death models and connections to the sampling-based coalescent"
}
\examples{
\donttest{
df <- birthDeathMCMC(cloneRate::exampleUltraTrees[[1]])
}

}
\seealso{
\link{internalLengths} \link{maxLikelihood} which use
alternative methods for growth rate estimation from an ultrametric tree.
}
