% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mat2df}
\alias{mat2df}
\title{Converting matrix of responses into a long-form data frame and incorporating
covariates, if supplied.}
\usage{
mat2df(mat, xr.df = NULL, xc.df = NULL)
}
\arguments{
\item{mat}{matrix of responses to be clustered}

\item{xr.df}{optional data frame of covariates corresponding to the rows of
\code{mat}. Each row of \code{xr.df} corresponds to one row of \code{mat},
and each column of \code{xr.df} is a covariate.}

\item{xc.df}{optional data frame of covariates corresponding to the columns
of \code{mat}. Each row of \code{xc.df} corresponds to one \strong{column}
of \code{mat}, and each column of \code{xc.df} is a covariate.}
}
\value{
A data frame with columns \code{Y}, \code{ROW} and \code{COL}, and
   additional columns for covariates from \code{xr.df} and \code{xc.df}, if
   included.

   The \code{Y} column of the output contains the entries in \code{mat}, with
   one row in the output per one cell in \code{mat}, and the \code{ROW} and
   \code{COL} entries indicate the row and column of the data matrix that
   correspond to the given cell. Any cells that were NA are left out of the
   output data frame.

   If \code{xr.df} is supplied, then there are additional columns in the
   output corresponding to the columns of \code{xr.df}, and the values for
   each covariate are repeated for every entry that was in the corresponding
   row of the data matrix.

   Similarly, if \code{xc.df} is supplied, there are additional columns in
   the output corresponding to the columns of \code{xc.df}, and the values
   for each covariate are repeated for every entry that was in the
   corresponding column of the data matrix.
}
\description{
Converting matrix of responses into a long-form data frame and incorporating
covariates, if supplied.
}
