% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{compute_grad}
\alias{compute_grad}
\title{Compute the Numerical Gradient of the Log-Likelihood}
\usage{
compute_grad(param)
}
\arguments{
\item{param}{A numeric vector of parameters for which the gradient is calculated.}
}
\value{
A numeric vector of the same length as \code{param}, representing the gradient at the specified parameters.
}
\description{
Calculates the gradient of the negative log-likelihood using finite differences.
The function uses a small step size (\code{h}) defined during initialization.
}
\details{
This function approximates the gradient using central finite differences.
Ensure that \code{h} is appropriately set to avoid numerical instability.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
param <- c(0.5, 0.1, 0.6, 0.2)
compute_grad(param)
}
