% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats.R
\name{format_stats}
\alias{format_stats}
\title{Format statistical results}
\usage{
format_stats(x, ...)
}
\arguments{
\item{x}{Statistical object.}

\item{...}{Additional arguments passed to methods. For method-specific
arguments, see \code{\link[=format_stats.htest]{format_stats.htest()}} for htest correlations, t-tests,
and Wilcoxon tests, \code{\link[=format_stats.easycorrelation]{format_stats.easycorrelation()}} for easycorrelation
correlations, \code{\link[=format_stats.lm]{format_stats.lm()}} for linear models,
\code{\link[=format_stats.merMod]{format_stats.merMod()}} and \code{\link[=format_stats.lmerModLmerTest]{format_stats.lmerModLmerTest()}} for
linear mixed models, and
\code{\link[=format_stats.BFBayesFactor]{format_stats.BFBayesFactor()}} for Bayes factors from the
\{\href{https://cran.r-project.org/package=BayesFactor}{BayesFactor}\} package.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
A generic function that takes objects from various statistical methods to
create formatted character strings to insert into R Markdown or Quarto
documents. Currently, the generic function works with the following objects:
\enumerate{
\item \code{htest} objects of correlations, t-tests, and Wilcoxon tests
\item correlations from the
\{\href{https://cran.r-project.org/package=correlation}{correlation}\} package.
\item \code{aov} objects for ANOVAs
\item Bayes factors from the
\{\href{https://cran.r-project.org/package=BayesFactor}{BayesFactor}\} package.
The function invokes specific methods that depend on the class of the
first argument.
}
}
\examples{
# Format cor.test() object
format_stats(cor.test(mtcars$mpg, mtcars$cyl))

# Format correlation::correlation() object
format_stats(correlation::correlation(data = mtcars, select = "mpg", select2 = "cyl"))

# Format t.test() object
format_stats(t.test(mtcars$vs, mtcars$am))

# Format aov() object
format_stats(aov(mpg ~ cyl * hp, data = mtcars), term = "cyl")

# Format lm() or glm() object
format_stats(lm(mpg ~ cyl * hp, data = mtcars), term = "cyl")
format_stats(glm(am ~ cyl * hp, data = mtcars, family = binomial), term = "cyl")

# Format lme4::lmer() or lme4::glmer() object
format_stats(lme4::lmer(mpg ~ hp + (1 | cyl), data = mtcars), term = "hp")
format_stats(lme4::glmer(am ~ hp + (1 | cyl), data = mtcars, family = binomial), term = "hp")

# Format lmerTest::lmer() object
format_stats(lmerTest::lmer(mpg ~ hp + (1 | cyl), data = mtcars), term = "hp")

# Format BFBayesFactor object from {BayesFactor} package
format_stats(BayesFactor::ttestBF(mtcars$vs, mtcars$am))
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_chisq}()},
\code{\link{format_corr}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
