% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{ilr_basis}
\alias{ilr_basis}
\alias{olr_basis}
\title{Isometric/Orthonormal Log-Ratio Basis for Log-Transformed Compositions}
\usage{
ilr_basis(dim, type = "default")

olr_basis(dim, type = "default")
}
\arguments{
\item{dim}{An integer indicating the number of components.
If a dataframe or matrix is provided, the number of components is inferred from the number of columns. If a character vector specifying the names of the parts is provided the number of component is its length.}

\item{type}{Character string specifying the type of basis to generate.
Options are \code{"pivot"}, \code{"cdp"}. Any other option will return the Helmert basis defined by Egozcue et al., 2013..}
}
\value{
A matrix representing the orthonormal basis.
}
\description{
Builds an isometric log-ratio (ilr) basis for a composition with \code{k+1} parts, also called orthonormal log-ratio (olr) basis.
}
\details{
The basis vectors are constructed as:
\deqn{h_i = \sqrt{\frac{i}{i+1}} \log\frac{\sqrt[i]{\prod_{j=1}^i x_j}}{x_{i+1}}}{%
h[i] = sqrt(i/(i+1)) * ( log(x[1] * ... * x[i]) / i - log(x[i+1]) )}
for \eqn{i = 1, \ldots, k}.

Setting the \code{type} parameter to \code{"pivot"} (pivot balances) or \code{"cdp"} (codapack balances) allows generating alternative ilr/olr bases.
}
\examples{
ilr_basis(5)
ilr_basis(alimentation[,1:9])
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Mateu-Figueras, G., & Barceló-Vidal, C. (2003).
\emph{Isometric logratio transformations for compositional data analysis}.
Mathematical Geology, \strong{35}(3), 279–300.
}
