% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary_diagram.R
\name{ternary_diagram}
\alias{ternary_diagram}
\title{Ternary Diagram}
\usage{
ternary_diagram(
  X,
  group = NULL,
  center = FALSE,
  scale = FALSE,
  show_pc = FALSE
)
}
\arguments{
\item{X}{A numeric matrix or data frame of compositional data with exactly three columns.}

\item{group}{A factor or character vector indicating groups for color coding (optional).}

\item{center}{Logical. Should the data be centered before plotting? Default is FALSE.}

\item{scale}{Logical. Should the data be scaled to unit variance? Default is FALSE.}

\item{show_pc}{Logical. If TRUE, principal components are overlaid. Default is FALSE.}
}
\value{
A \code{ggplot} plot object (inherits from \code{ggplot}).
}
\description{
Generates a ternary diagram from compositional data, with options to center, scale,
and color the points by group. Optionally overlays principal components.
}
\examples{

X = milk_cows[,5:7]
group = milk_cows$group
ternary_diagram(X, group = group)

}
