% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoef.r
\name{extract.coef.xgb.Booster}
\alias{extract.coef.xgb.Booster}
\title{extract.coef.xgb.Booster}
\usage{
\method{extract.coef}{xgb.Booster}(
  model,
  feature_names = NULL,
  removeNonSelected = TRUE,
  zero_threshold = 0.001,
  ...
)
}
\arguments{
\item{model}{Model object from which to extract information.}

\item{feature_names}{Names of coefficients}

\item{removeNonSelected}{If \code{TRUE} (default) do not return the non-selected (0) coefficients}

\item{zero_threshold}{Since \code{coefficients} from 
\code{\link[xgboost]{xgboost}} are not exactly zero, 
this is the threshold under which a coefficient is considered zero}

\item{\dots}{Further arguments}
}
\value{
A \code{\link{data.frame}} containing the coefficient, the standard 
error and the variable name.
}
\description{
Extract Coefficient Information from Models
}
\details{
Gets the coefficient values and variable names from a model. Since 
xgboost does not have standard errors, those will just be NA.
}
\examples{
\dontshow{
if(requireNamespace('xgboost', quietly=TRUE))\{}
library(xgboost)
data(diamonds, package='ggplot2')
diaX <- useful::build.x(price ~ carat + cut + x, data=diamonds, contrasts=FALSE)
diaY <- useful::build.y(price ~ carat + cut + x, data=diamonds)
xg1 <- xgb.train(data=xgb.DMatrix(data=diaX, label=diaY), 
booster='gblinear',
objective='reg:squarederror', eval_metric='rmse',
nrounds=50
)
extract.coef(xg1)
extract.coef(xg1, zero_threshold=0)
extract.coef(xg1, feature_names=colnames(diaX))
\dontshow{\}}

}
\author{
Jared P. Lander
}
