% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dich_response_model.R
\name{dich_response_model}
\alias{dich_response_model}
\title{Dichotomous Response Model}
\usage{
dich_response_model(
  y = NULL,
  omega = NULL,
  gamma = NULL,
  lambda = NULL,
  zeta = NULL,
  nu = NULL,
  kappa = NULL,
  link = NULL
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{omega}{Contrast effects matrix (K by
MN).}

\item{gamma}{Contrast codes matrix (JM by MN).}

\item{lambda}{Item slope matrix (IJ by JM).}

\item{zeta}{Specific effects matrix (K by
JM).}

\item{nu}{Item intercept matrix  (IJ by 1).}

\item{kappa}{Item guessing matrix  (IJ by 1).}

\item{link}{Choose between "logit" or "probit" link functions.}
}
\value{
p = response probability matrix (K by IJ); yhatstar = latent response
variate matrix (K by IJ); loglikelihood = model log-likelihood (scalar).
}
\description{
This function calculates predictions and log-likelihood values for a
dichotomous response model framed using generalized latent variable modeling
(GLVM; Skrondal & Rabe-Hesketh, 2004).
}
\section{Dimensions}{

I = Number of items per condition; J = Number of conditions; K = Number of
examinees; M Number of ability (or trait) dimensions; N Number of contrasts
(should include intercept).
}

\references{
Skrondal, A., & Rabe-Hesketh, S. (2004). \emph{Generalized latent variable
modeling: Multilevel, longitudinal, and structural equation models}. Boca
Raton: Chapman & Hall/CRC.
}
