% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R, R/source_tblist.R
\name{filter-source-types}
\alias{filter-source-types}
\alias{cb_filter.discrete}
\alias{cb_filter.discrete_text}
\alias{cb_filter.range}
\alias{cb_filter.date_range}
\alias{cb_filter.datetime_range}
\alias{cb_filter.multi_discrete}
\alias{cb_filter.query}
\alias{cb_filter.discrete.tblist}
\alias{cb_filter.discrete_text.tblist}
\alias{cb_filter.range.tblist}
\alias{cb_filter.date_range.tblist}
\alias{cb_filter.datetime_range.tblist}
\alias{cb_filter.multi_discrete.tblist}
\alias{cb_filter.query.tblist}
\title{Filter Source types methods}
\usage{
cb_filter.discrete(source, ...)

cb_filter.discrete_text(source, ...)

cb_filter.range(source, ...)

cb_filter.date_range(source, ...)

cb_filter.datetime_range(source, ...)

cb_filter.multi_discrete(source, ...)

cb_filter.query(source, ...)

\method{cb_filter.discrete}{tblist}(
  source,
  type = "discrete",
  id = .gen_id(),
  name = id,
  variable,
  value = NA,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.discrete_text}{tblist}(
  source,
  type = "discrete_text",
  id = .gen_id(),
  name = id,
  variable,
  value = NA,
  dataset,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.range}{tblist}(
  source,
  type = "range",
  id = .gen_id(),
  name = id,
  variable,
  range = NA,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.date_range}{tblist}(
  source,
  type = "date_range",
  id = .gen_id(),
  name = id,
  variable,
  range = NA,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.datetime_range}{tblist}(
  source,
  type = "datetime_range",
  id = .gen_id(),
  name = id,
  variable,
  range = NA,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.multi_discrete}{tblist}(
  source,
  type = "multi_discrete",
  id = .gen_id(),
  name = id,
  values,
  variables,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)

\method{cb_filter.query}{tblist}(
  source,
  type = "query",
  id = .gen_id(),
  name = id,
  variables,
  value = NA,
  dataset,
  keep_na = TRUE,
  ...,
  description = NULL,
  active = TRUE
)
}
\arguments{
\item{source}{Source object.}

\item{...}{Source type specific parameters (or extra ones if not matching specific S3 method arguments).}

\item{type}{Character string defining filter type (having class of the same value as type).}

\item{id}{Id of the filter.}

\item{name}{Filter name.}

\item{variable}{Dataset variable used for filtering.}

\item{value}{Value(s) to be used for filtering.}

\item{dataset}{Dataset name to be used for filtering.}

\item{keep_na}{If `TRUE`, NA values are included.}

\item{description}{Filter description (optional).}

\item{active}{If FALSE filter will be skipped during Cohort filtering.}

\item{range}{Variable range to be applied in filtering.}

\item{values}{Named list of values to be applied in filtering.
The names should relate to the ones included in `variables` parameter.}

\item{variables}{Dataset variables used for filtering.}
}
\value{
List of filter-specific metadata and methods - result of evaluation of
   `cb_filter_constructor` function on `Source` object.
}
\description{
Filter Source types methods
}
