% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onedim_dist.R
\name{onedim_dist}
\alias{onedim_dist}
\title{Create a colocalization matrix}
\usage{
onedim_dist(bed1, bed2, n)
}
\arguments{
\item{bed1}{A .bed table}

\item{bed2}{A .bed table}

\item{n}{The cut-off distance}
}
\value{
A colocalization matrix whose dimensions are the number of rows in
 \code{bed1} by the number of rows in \code{bed2}. Entry i,j is a 1 if the ith
 sequence in \code{bed1} is within the cut-off distance of the jth sequence
 in \code{bed2}, and 0 otherwise.
}
\description{
Create a colocalization matrix
}
\examples{
chr<-"chrY"
onedim_dist(nfkb1[which(nfkb1[,1]==chr),],nfkb2[which(nfkb2[,1]==chr),],150)
}
