% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marks.R
\name{marks}
\alias{marks}
\title{Calculate marks for track and field combined events}
\usage{
marks(scores, gender, combined_event = NULL, seconds = FALSE)
}
\arguments{
\item{scores}{a numeric vector of track and field scores}

\item{gender}{gender of athlete; either "\code{male}" or "\code{female}"}

\item{combined_event}{an optional character string indicating the
combined events competition. For \code{gender = "male"}, the options are
"\code{decathlon}"/"\code{outdoor decathlon}", "\code{outdoor pentathlon}",
"\code{heptathlon}"/"\code{indoor heptathlon}", and "\code{indoor pentathlon}".
For \code{gender = "female"}, the options are "\code{heptathlon}"/"\code{outdoor heptathlon}",
"\code{decathlon}"/"\code{outdoor decathlon}", and "\code{pentathlon}"/"\code{indoor pentathlon}".
If \code{combined_event = NULL}, the elements of \code{scores} must be named.
\itemize{
\item For \code{gender = "male"}, the allowed names for the elements
of \code{scores} are \code{`100m`}, \code{LJ}, \code{SP}, \code{HJ}, \code{`400m`}, \code{`110mH`}, \code{DT}, \code{PV}, \code{JT}, \code{`1500m`},
\code{`200m`}, \code{`60m`}, \code{`60mH`}, and \code{`1000m`}.
\item For \code{gender = "female"}, the allowed names are \code{`100m`}, \code{LJ},
\code{SP}, \code{HJ}, \code{`400m`}, \code{`100mH`}, \code{DT}, \code{PV}, \code{JT}, \code{`1500m`}, \code{`200m`}, \code{`60mH`}, and \code{`800m`}.
}}

\item{seconds}{a logical; if \code{TRUE}, will return all track event marks in seconds}
}
\value{
A list of class "\code{combined_events}" (or "\code{combined_events_null}" if \code{combined_event = NULL}) with
the following fields:
\item{results}{if called with non-NULL \code{combined_event}, a data frame with
columns for the specified combined event containing the names of those events, \code{mark}
for the resulting marks based on the input scores, and \code{score} based on the input
scores. The last row of the data frame gives the total score for the specified combined
events competition. If \code{combined_event = NULL}, a data frame with columns \code{event},
\code{mark}, and \code{score}.}
\item{marks}{the vector of marks based on the input scores for the specified combined event.
If not all scores were supplied to \code{marks()}, then there will be \code{NA} values
for those events with missing scores. If \code{combined_event = NULL}, the vector of marks.}
\item{scores}{the vector of scores for the specified combined event. If not all scores
were supplied to \code{marks()}, then there will be \code{NA} values for those events with
missing scores. If \code{combined_event = NULL}, the vector of scores.}
\item{score_total}{if called with non-NULL \code{combined_event}, an integer representing the overall score
for the specified combined events competition}
\item{call}{the matched call}
}
\description{
\code{marks()} calculates marks for track and field combined events competitions.
}
\details{
\code{marks()} performs the opposite action of \code{\link[=scores]{scores()}}:
you give it the scores you want to obtain, and it gives you the marks you
need to achieve those scores. For track events, \code{marks()} returns the
slowest time needed to achieve the input score. Similarly, for jumping and
throwing events, \code{marks()} returns the shortest distance necessary to
achieve the input score.

For some events, when a score is given to \code{marks()}, the score returned may
be different from the one input because some scores are not actually
possible (due to rounding of track and field marks). When an impossible
score is given to \code{marks()}, the function will return the closest higher
score that corresponds to a mark.
}
\examples{
# Men's heptathlon
marks(scores = rep(800, 7),
      gender = "male", combined_event = "heptathlon")

# Women's pentathlon
marks(scores = c(`60mH` = 981, HJ = 875, SP = 799, LJ = 956, `800m` = 1000),
      "female", "pentathlon")

# Men's events
marks(scores = c(LJ = 790, LJ = 810, HJ = 850, HJ = 900, PV = 900, PV = 915),
      "male")
}
\references{
International Association of Athletics Federation (2001).
\emph{IAAF Scoring Tables for Combined Events}.
}
