% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_markers.R
\name{show_markers}
\alias{show_markers}
\title{Show the composition of combinations.}
\usage{
show_markers(markers_table, selected_combinations)
}
\arguments{
\item{markers_table}{a data.frame with combinations returned by combi().}

\item{selected_combinations}{a numeric vector that specifies the combinations of interest.}
}
\value{
a data.frame containing the selected combinations and their composing markers.
}
\description{
A function to show the composition of combinations of interest.
}
\examples{
\dontrun{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

combs <- combi(data= demo_data, signalthr=450, combithr=1, case_class='A')  # compute combinations

#  To show the composition of combinations of interest.

show_markers(markers_table = combs, selected_combinations = c(1,11))
}
}
