% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{call_api}
\alias{call_api}
\title{Call a Comet REST API endpoint}
\usage{
call_api(
  endpoint,
  method = c("GET", "POST"),
  params = list(),
  parse_response = TRUE,
  response_json = TRUE,
  local_file_path = NULL,
  api_key = NULL
)
}
\arguments{
\item{endpoint}{The REST API endpoint.}

\item{method}{The HTTP method to use, either "GET" or "POST".}

\item{params}{A list of parameters. For GET endpoints, the parameters are appended
to the URL; for POST endpoints, the parameters are sent in the body of the request.}

\item{parse_response}{If \code{TRUE}, try to parse response from server.}

\item{response_json}{If \code{TRUE}, try to parse the response as JSON. If \code{FALSE}, return
the response as raw data, e.g. binary.}

\item{local_file_path}{The path to the local file for saving downloaded content
if appropriate.}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}
}
\value{
The parsed response
}
\description{
This function is only meant for advanced users. If you would like to call any
arbitrary Comet API endpoint that isn't natively supported by \code{cometr}, you can
use this function.
}
