% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JaroWinkler.R
\name{JaroWinkler}
\alias{JaroWinkler}
\title{Jaro-Winkler String/Sequence Comparator}
\usage{
JaroWinkler(
  p = 0.1,
  threshold = 0.7,
  max_prefix = 4L,
  similarity = TRUE,
  ignore_case = FALSE,
  use_bytes = FALSE
)
}
\arguments{
\item{p}{a non-negative numeric scalar no larger than 1/max_prefix.
Similarity scores eligible for boosting are scaled by this factor.}

\item{threshold}{a numeric scalar on the unit interval. Jaro similarities
greater than this value are boosted based on matching characters in the
prefixes of both strings. Jaro similarities below this value are
returned unadjusted. Defaults to 0.7.}

\item{max_prefix}{a non-negative integer scalar, specifying the size of
the prefix to consider for boosting. Defaults to 4 (characters).}

\item{similarity}{a logical. If TRUE, similarity scores are returned
(default), otherwise distances are returned (see definition under Details).}

\item{ignore_case}{a logical. If TRUE, case is ignored when comparing
strings.}

\item{use_bytes}{a logical. If TRUE, strings are compared byte-by-byte
rather than character-by-character.}
}
\value{
A \code{JaroWinkler} instance is returned, which is an S4 class inheriting from
\code{\linkS4class{StringComparator}}.
}
\description{
The Jaro-Winkler comparator is a variant of the \code{\link{Jaro}} comparator which
boosts the similarity score for strings/sequences with matching prefixes.
It was developed for comparing names at the U.S. Census Bureau.
}
\details{
For simplicity we assume \code{x} and \code{y} are strings in this section,
however the comparator is also implemented for more general sequences.

The Jaro-Winkler similarity (computed when \code{similarity = TRUE}) is
defined in terms of the \code{\link{Jaro}} similarity. If the Jaro similarity
\eqn{sim_J(x,y)} between strings \eqn{x} and \eqn{y} exceeds a
user-specified threshold \eqn{0 \leq \tau \leq 1}{0 <= threshold <= 1},
the similarity score is boosted in proportion to the number of matching
characters in the prefixes of \eqn{x} and \eqn{y}. More precisely, the
Jaro-Winkler similarity is defined as:
\deqn{\mathrm{sim}_{JW}(x, y) = \mathrm{sim}_J(x, y) + \min(c(x, y), l) p (1 - \mathrm{sim}_J(x, y)),}{sim_{JW}(x, y) = sim_J(x, y) + min(c(x, y), l) p (1 - sim_J(x, y)),}
where \eqn{c(x,y)} is the length of the common prefix, \eqn{l \geq 0}{l >= 0}
is a user-specified upper bound on the prefix size, and
\eqn{0 \leq p \leq 1/l}{0 <= p <= 1/l} is a scaling factor.

The Jaro-Winkler distance is computed when \code{similarity = FALSE} and is
defined as
\deqn{\mathrm{dist}_{JW}(x, y) = 1 - \mathrm{sim}_{JW}(x, y).}{dist_{JW}(x, y) = 1 - sim_{JW}(x, y).}
}
\note{
Like the Jaro distance, the Jaro-Winkler distance is not a metric as
it does not satisfy the identity axiom.
}
\examples{
## Compare names
JaroWinkler()("Martha", "Mathra")
JaroWinkler()("Eileen", "Phyllis")

## Reduce the threshold for boosting
x <- "Matthew"
y <- "Martin"
JaroWinkler()(x, y) < JaroWinkler(threshold = 0.5)(x, y)

}
\references{
Jaro, M. A. (1989), "Advances in Record-Linkage Methodology as Applied to
Matching the 1985 Census of Tampa, Florida", \emph{Journal of the American
Statistical Association} \strong{84}(406), 414-420.

Winkler, W. E. (2006), "Overview of Record Linkage and Current Research
Directions", Tech. report. Statistics #2006-2. Statistical Research
Division, U.S. Census Bureau.

Winkler, W., McLaughlin G., Jaro M. and Lynch M. (1994), \href{https://web.archive.org/web/20100227020019/http://www.census.gov/geo/msb/stand/strcmp.c}{strcmp95.c},
Version 2. United States Census Bureau.
}
\seealso{
This comparator reduces to the \code{\link{Jaro}} comparator when \code{max_prefix = 0L}
or \code{threshold = 0.0}.
}
