% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.calibrate.set.R
\name{logistic.calibrate.set}
\alias{logistic.calibrate.set}
\title{Calculate the calibrated set of LRs with the logistic regression}
\usage{
logistic.calibrate.set(LR.ss, LR.ds)
}
\arguments{
\item{LR.ss}{a vector of likelihood ratios for the comparisons of items known to be from the same source}

\item{LR.ds}{a vector of likelihood ratios for the comparisons of items known to be from different sources}
}
\value{
a \code{list} with multiple items: \describe{
\item{prior.odds}{prior odds for the input data}
\item{coefficients}{coefficients of the fitted model}
\item{data}{The input and calibrated data}
\item{LR.cal.ss}{The calibrated data for the same source list}
\item{LR.cal.ds}{The calibrated data for the different-sources list}
}
}
\description{
Calculate the calibrated set of LRs with the logistic regression
}
\examples{
LR.same = c(0.5, 2, 4, 6, 8, 10)              # the list of LRs for the same source proposition
LR.different = c(0.2, 0.4, 0.6, 0.8, 1.1)     # the list of LRs for the different source proposition
logistic.calibrate.set(LR.same, LR.different) # compute the logistic calibration on the data

}
\seealso{
\code{\link[=logistic.apply.calibration]{logistic.apply.calibration()}}
}
\author{
Marco De Donno
}
