% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.R
\name{forwdif}
\alias{forwdif}
\title{Forward differences}
\usage{
forwdif(f)
}
\arguments{
\item{f}{A vector of real numbers. Tabulated (known) values 
of the function, corresponding to a regular grid.}
}
\value{
An upper triangular matrix with \eqn{n+1} rows and
\eqn{n+1} columns. The first column includes the tabulated 
values of the function. The second column includes the \eqn{n}
forward differences of first order and a zero. The third
column includes the \eqn{n-1} forward differences of second
order and two zeros. And so on.
}
\description{
Computes forward differences of all orders up to n, based
on n+1 tabulated points on a regular grid.
}
\details{
The forward difference of first order is
\deqn{
 f(x_i+h)-f(x_i)
}
Forward differences of higher orders follow from this one,
where the function \eqn{f} is replaced by the forward
difference of previous order. All values are contained in a
\eqn{(n+1)\times(n+1)} upper triangular matrix.
}
\examples{
# Tabulated values: f(x) = x^3+x^2-x-1
x <- c(0,1,2,3)
f <- x^3+x^2-x-1

# Triangular matrix with forward differences
F <- forwdif(f)
print(F)

}
