% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex2Matrix.R
\name{complex2mat}
\alias{complex2mat}
\alias{complex2vec}
\alias{mat2complex}
\alias{vec2complex}
\title{Functions to manipulate complex variables and matrices}
\usage{
complex2mat(x)

complex2vec(x)

mat2complex(x)

vec2complex(x)
}
\arguments{
\item{x}{vector or matrix of complex variables.}
}
\value{
A matrix with real and imaginary parts of x split into columns (and rows in case
of \code{complex2mat()}).

#' @references \itemize{
\item Svetunkov, S. & Svetunkov I (2022) Complex Autoregressions. In Press.
}
}
\description{
\code{complex2mat()} constructs a matrix from the provided complex variable,
while \code{complex2vec()} returns a vector (in mathematical sense), both of them
split the real and imaginary parts. \code{mat2complex()} and \code{vec2complex()} do
the reverse of the respective functions. See details for explanation.
}
\details{
Complex variable x + iy can be represented as a vector (x y)' or as a matrix:
(x -y)
(y  x)

\code{complex2mat()} returns the latter, while \code{complex2vec()} returns the
former. If a user provides a vector of complex variables, the values are stacked above
each other. If a matrix is provided, a higher dimensional matrix is returned.

\code{mat2complex()} and \code{vec2complex()} return complex variables based on provided
matrix.

The function is needed to calculate some statistics for complex variables in vector form.
}
\examples{

# Generate random complex variables
x <- complex(real=rnorm(100,10,10), imaginary=rnorm(100,10,10))

# Get a matrix and a vector for one value
complex2mat(x[1])
complex2vec(x[1])

# Get matrices for all values
complex2mat(x)
complex2vec(x)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\code{\link[complex]{clm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{univar}
