% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_sequences.R
\name{rename_sequences}
\alias{rename_sequences}
\title{Rename sequences}
\usage{
rename_sequences(
  fasta_files,
  df = NULL,
  filename = NULL,
  marker_names = NULL,
  out = NULL,
  format = "fasta",
  excel.sheet = 1,
  unalign = FALSE,
  exclude
)
}
\arguments{
\item{fasta_files}{Optional, a vector of paths to the fasta files that should be renamed. If this argument is missing, the function automatically detects and uses all the fasta files present in the working directory.}

\item{df}{The user-defined correspondence table, as a data frame or equivalent. This is used only if no \code{filename} argument is provided.}

\item{filename}{Filename of correspondence table. Alternatively, if no filename is provided, the user can provide their own correspondence table as the \code{df} argument.}

\item{marker_names}{the name of the marker for each alignment to be appended at the end of the sequences names, in the same order as in the correspondence table}

\item{out}{specify outputs filename}

\item{format}{a string specifying in what formats you want the alignment. Can be "fasta", "phylip" and "nexus"}

\item{excel.sheet}{specify what sheet from the excel spreadsheet you wanna read. Either a string (the name of a sheet), or an integer (the position of the sheet).}

\item{unalign}{return unaligned fasta files as output}

\item{exclude}{Optional regular expression used to exclude some filenames from the list of detected files.}
}
\value{
No return value, called for side effect of saving a correspondence table.
}
\description{
This function renames sequences in fasta files based on a correspondence table.
}
