% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\name{concstats_dom}
\alias{concstats_dom}
\title{Dominance Index}
\usage{
concstats_dom(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if the vector
contains \code{NA} values.}
}
\value{
A single numeric measure in decimal form.
}
\description{
Dominance Index
}
\details{
\code{concstats_dom} calculates a dominance index, which measures the
concentration within the Herfindahl-Hirschman index, that is, the
concentration within the concentration.
}
\examples{
# a vector of market shares
x <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
concstats_dom(x)
# a vector with NA values
x <- c(0.4, 0.2, 0.25, 0.1, 0.05, NA)
concstats_dom(x, na.rm = FALSE)

}
\references{
Garcia Alba Idunate, P. (1994). "Un Indice de dominancia para el
analisis de la estructura de los mercados". \emph{El Trimestre Economico},
61: 499-524.
}
