% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmvtruncnorm.R
\name{rcmvtruncnorm}
\alias{rcmvtruncnorm}
\title{Random Sample from Conditional Truncated Multivariate Normal}
\usage{
rcmvtruncnorm(
  n,
  mean,
  sigma,
  lower,
  upper,
  dependent.ind,
  given.ind,
  X.given,
  init = rep(0, length(mean)),
  burn = 10L,
  thin = 1
)
}
\arguments{
\item{n}{number of random samples desired (sample size).}

\item{mean}{the mean vector for Z of length of n}

\item{sigma}{the symmetric and positive-definite covariance matrix of dimension n x n of Z.}

\item{lower}{a vector of lower bounds of length n that truncate Z}

\item{upper}{a vector of upper bounds of length n that truncate Z}

\item{dependent.ind}{a vector of integers denoting the indices of dependent variable Y.}

\item{given.ind}{a vector of integers denoting the indices of conditioning variable X.  If specified as integer vector of length zero or left unspecified, the unconditional density is returned.}

\item{X.given}{a vector of reals denoting the conditioning value of X. This should be of the same length as \code{given.ind}}

\item{init}{initial value used for random generation of truncated multivariate normal in a Gibbs sampler. Default: A vector of zeros, equal to the number of components. For details, see **tmvmixnorm::**\code{\link[tmvmixnorm]{rtmvn}}().}

\item{burn}{the burn-in, which is the number of initial iterations to be discarded. Default: 10. Passed to \code{\link[tmvmixnorm]{rtmvn}}().}

\item{thin}{thinning lag (default as \code{1}).}
}
\description{
Randomly samples from conditional truncated multivariate normal distribution variate, \strong{Y|X}, where \strong{Z = (X, Y)} is the fully joint multivariate normal distribution with \code{mean}, covariance matrix \code{sigma}, and truncated between \code{lower} and \code{upper}.  See the vignette for more information.
}
\note{
Uses \code{\link[tmvmixnorm]{rtmvn}} from the \strong{tmvmixnorm} package to find the random variate.
}
\examples{
# Generate 2 random numbers from X2,X3,X5|X2,X4 ~ N_3(1, Sigma)
# truncated between -10 and 10.
d <- 5
rho <- 0.9
Sigma <- matrix(0, nrow = d, ncol = d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

set.seed(2342)
rcmvtruncnorm(2,
  mean = rep(1, d),
  sigma = Sigma,
  lower = rep(-10, d),
  upper = rep(10, d),
  dependent.ind = c(2, 3, 5),
  given.ind = c(1, 4), X.given = c(1, -1)
)

# Example 2: Generate two random numbers from
# X1|X2, X3, X4, X5 ~ N(1, Sigma) truncated between -10 and 10.
set.seed(2342)
rcmvtruncnorm(2,
  mean = rep(1, d),
  sigma = Sigma,
  lower = rep(-10, d),
  upper = rep(10, d),
  dependent.ind = 1,
  given.ind = 2:5, X.given = c(1, -1, 1, -1)
)
}
