% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-accounts.R
\name{connect_service_account_token}
\alias{connect_service_account_token}
\alias{has_service_account_token}
\title{Service account credentials on Posit Connect}
\usage{
connect_service_account_token(
  resource = NULL,
  scope = NULL,
  content_token = Sys.getenv("CONNECT_CONTENT_SESSION_TOKEN"),
  server_url = Sys.getenv("CONNECT_SERVER"),
  api_key = Sys.getenv("CONNECT_API_KEY")
)

has_service_account_token(...)
}
\arguments{
\item{resource}{The URI that identifies the resource that the client is
trying to access, if applicable.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{content_token}{A token that uniquely identifies this content session.
Defaults to the value of the \code{CONNECT_CONTENT_SESSION_TOKEN} environment
variable, which is set automatically when running on Connect.}

\item{server_url}{The Connect server to exchange credentials with. Defaults
to the value of the \code{CONNECT_SERVER} environment variable, which is set
automatically when running on Connect.}

\item{api_key}{An API key for the Connect server. Defaults to the value of
the \code{CONNECT_API_KEY} environment variable, which is set automatically when
running on Connect.}

\item{...}{Further arguments passed on to \code{\link[=connect_service_account_token]{connect_service_account_token()}}.}
}
\value{
\code{\link[=connect_service_account_token]{connect_service_account_token()}} returns an \link[httr2:oauth_token]{httr2::oauth_token}.

\code{\link[=has_service_account_token]{has_service_account_token()}} returns \code{TRUE} if there is a
Connect-managed service account avaiable and \code{FALSE} otherwise.
}
\description{
Request an OAuth access token for a third-party resource from Posit Connect.
The OAuth token will belong to the client (usually a "service principal" or
"service account") managed by Connect, not the publisher.
}
\details{
\code{connect_service_account_token()} handles caching automatically.
}
\examples{
token <- "default-token"
if (has_service_account_token()) {
  token <- connect_service_account_token()
}
}
