% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mocking.R
\name{with_mocked_connect_responses}
\alias{with_mocked_connect_responses}
\alias{local_mocked_connect_responses}
\title{Mock responses from the Posit Connect server}
\usage{
with_mocked_connect_responses(
  code,
  mock = NULL,
  token = NULL,
  error = FALSE,
  env = caller_env()
)

local_mocked_connect_responses(
  mock = NULL,
  token = NULL,
  error = FALSE,
  env = caller_env()
)
}
\arguments{
\item{code}{Code to execute in the temporary environment.}

\item{mock}{A function, a list, or \code{NULL}.
\itemize{
\item \code{NULL} disables mocking and returns httr2 to regular operation.
\item A list of responses will be returned in sequence. After all responses
have been used up, will return 503 server errors.
\item For maximum flexibility, you can supply a function that that takes a
single argument, \code{req}, and returns either \code{NULL} (if it doesn't want to
handle the request) or a \link[httr2]{response} (if it does).
}}

\item{token}{When not \code{NULL}, return this token from the Connect server.}

\item{error}{When \code{TRUE}, return an error from the Connect server.}

\item{env}{Environment to use for scoping changes.}
}
\value{
\code{\link[=with_mocked_connect_responses]{with_mocked_connect_responses()}} returns the result of evaluating
\code{code}.
}
\description{
These functions can be used to temporarily mock responses from the Connect
server, which is useful for writing tests that verify the behaviour of
viewer-based or service account credentials.
}
\examples{
with_mocked_connect_responses(
  connect_viewer_token(),
  token = "test"
)

with_mocked_connect_responses(
  connect_service_account_token(),
  token = "test"
)
}
