% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/table_methods.R,
%   R/volume_methods.R
\name{read_cnt}
\alias{read_cnt}
\alias{read_cnt.ConnectorDatabricksTable}
\alias{read_cnt.ConnectorDatabricksVolume}
\title{Read content from the connector}
\usage{
read_cnt(connector_object, name, ...)

\method{read_cnt}{ConnectorDatabricksTable}(connector_object, name, ..., timepoint = NULL, version = NULL)

\method{read_cnt}{ConnectorDatabricksVolume}(connector_object, name, ...)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to the
\code{\link[brickster:db_volume_read]{brickster::db_volume_read()}} method}

\item{timepoint}{Timepoint in \href{https://docs.databricks.com/gcp/en/delta/history#delta-time-travel-syntax}{Delta time travel syntax}
format.}

\item{version}{Table version generated by the operation.}
}
\value{
R object with the content. For rectangular data a \link{data.frame}.
}
\description{
Additional read methods for Databricks connectors implemented for
\code{\link[connector:read_cnt]{connector::read_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksTable}: Reuses the \code{\link[connector:read_cnt]{connector::read_cnt()}}
method for \link{ConnectorDatabricksTable}, but always
sets the \code{catalog} and \code{schema} as defined in when initializing the
connector.
}

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:read_cnt]{connector::read_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
