% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{add_metadata}
\alias{add_metadata}
\title{Add metadata to a YAML configuration file}
\usage{
add_metadata(config_path, key, value)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{key}{The key for the new metadata entry}

\item{value}{The value for the new metadata entry}
}
\value{
(invisible) \code{config_path} where the configuration have been updated
}
\description{
This function adds metadata to a YAML configuration file by modifying the provided
key-value pair in the metadata section of the file.
}
\examples{
config <- tempfile(fileext = ".yml")

file.copy(
  from = system.file("config", "_connector.yml", package = "connector"),
  to = config
)

config <- config |>
  add_metadata(
    key = "new_metadata",
    value = "new_value"
  )
config

}
