% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_centered.R
\name{is_centered}
\alias{is_centered}
\title{Check for intercept centering}
\usage{
is_centered(contrast_matrices, USE.NAMES = FALSE)
}
\arguments{
\item{contrast_matrices}{Contrast matrix or list of contrast matrices}

\item{USE.NAMES}{Logical, whether vector should be named}
}
\value{
Logical vector, will retain names of a passed list
}
\description{
Given a contrast matrix or list of contrast matrices (eg from
\code{\link[=enlist_contrasts]{enlist_contrasts()}}), return a logical vector of whether each contrast is
centered or not.
}
\examples{
is_centered(treatment_code(5)) # FALSE
is_centered(scaled_sum_code(5)) # TRUE

}
\seealso{
\code{\link[=is_orthogonal]{is_orthogonal()}}
}
